/*
 * Decompiled with CFR 0.152.
 */
package wile.rsgauges.libmc.detail;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import org.apache.logging.log4j.Logger;

public class PlayerBlockInteraction {
    public static void init(String modid, Logger logger) {
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, false, PlayerInteractEvent.class, PlayerBlockInteraction::onPlayerInteract);
    }

    public static void onPlayerInteract(PlayerInteractEvent event) {
        boolean is_lclick;
        Level world = event.getWorld();
        if (world.m_5776_()) {
            return;
        }
        boolean is_rclick = event instanceof PlayerInteractEvent.RightClickBlock && event.getHand() == InteractionHand.MAIN_HAND;
        boolean bl = is_lclick = event instanceof PlayerInteractEvent.LeftClickBlock && event.getHand() == InteractionHand.MAIN_HAND && event.getFace() != Direction.DOWN;
        if (!is_rclick && !is_lclick) {
            return;
        }
        BlockPos fromPos = event.getPos();
        for (Direction facing : Direction.values()) {
            if (event.getFace() == facing) continue;
            BlockPos pos = fromPos.m_142300_(facing);
            BlockState state = event.getWorld().m_8055_(pos);
            if (!(state.m_60734_() instanceof INeighbourBlockInteractionSensitive) || !((INeighbourBlockInteractionSensitive)state.m_60734_()).onNeighborBlockPlayerInteraction(world, pos, state, fromPos, event.getEntityLiving(), event.getHand(), is_lclick)) continue;
            event.setCancellationResult(InteractionResult.CONSUME);
        }
    }

    public static interface INeighbourBlockInteractionSensitive {
        default public boolean onNeighborBlockPlayerInteraction(Level world, BlockPos pos, BlockState state, BlockPos fromPos, LivingEntity entity, InteractionHand hand, boolean isLeftClick) {
            return false;
        }
    }
}

